<?php
/*
 * Copyright 2014 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */

namespace Google\Service\Compute;

class SecurityPolicy extends \Google\Collection
{
  public const TYPE_CLOUD_ARMOR = 'CLOUD_ARMOR';
  public const TYPE_CLOUD_ARMOR_EDGE = 'CLOUD_ARMOR_EDGE';
  public const TYPE_CLOUD_ARMOR_NETWORK = 'CLOUD_ARMOR_NETWORK';
  protected $collection_key = 'userDefinedFields';
  protected $adaptiveProtectionConfigType = SecurityPolicyAdaptiveProtectionConfig::class;
  protected $adaptiveProtectionConfigDataType = '';
  protected $advancedOptionsConfigType = SecurityPolicyAdvancedOptionsConfig::class;
  protected $advancedOptionsConfigDataType = '';
  protected $associationsType = SecurityPolicyAssociation::class;
  protected $associationsDataType = 'array';
  /**
   * [Output Only] Creation timestamp inRFC3339 text format.
   *
   * @var string
   */
  public $creationTimestamp;
  protected $ddosProtectionConfigType = SecurityPolicyDdosProtectionConfig::class;
  protected $ddosProtectionConfigDataType = '';
  /**
   * An optional description of this resource. Provide this property when you
   * create the resource.
   *
   * @var string
   */
  public $description;
  /**
   * Specifies a fingerprint for this resource, which is essentially a hash of
   * the metadata's contents and used for optimistic locking. The fingerprint is
   * initially generated by Compute Engine and changes after every request to
   * modify or update metadata. You must always provide an up-to-date
   * fingerprint hash in order to update or change metadata, otherwise the
   * request will fail with error412 conditionNotMet.
   *
   * To see the latest fingerprint, make get() request to the security policy.
   *
   * @var string
   */
  public $fingerprint;
  /**
   * [Output Only] The unique identifier for the resource. This identifier is
   * defined by the server.
   *
   * @var string
   */
  public $id;
  /**
   * [Output only] Type of the resource. Alwayscompute#securityPolicyfor
   * security policies
   *
   * @var string
   */
  public $kind;
  /**
   * A fingerprint for the labels being applied to this security policy, which
   * is essentially a hash of the labels set used for optimistic locking. The
   * fingerprint is initially generated by Compute Engine and changes after
   * every request to modify or update labels. You must always provide an up-to-
   * date fingerprint hash in order to update or change labels.
   *
   * To see the latest fingerprint, make get() request to the security policy.
   *
   * @var string
   */
  public $labelFingerprint;
  /**
   * Labels for this resource. These can only be added or modified by
   * thesetLabels method. Each label key/value pair must comply withRFC1035.
   * Label values may be empty.
   *
   * @var string[]
   */
  public $labels;
  /**
   * Name of the resource. Provided by the client when the resource is created.
   * The name must be 1-63 characters long, and comply withRFC1035.
   * Specifically, the name must be 1-63 characters long and match the regular
   * expression `[a-z]([-a-z0-9]*[a-z0-9])?` which means the first character
   * must be a lowercase letter, and all following characters must be a dash,
   * lowercase letter, or digit, except the last character, which cannot be a
   * dash.
   *
   * @var string
   */
  public $name;
  /**
   * [Output Only] The parent of the security policy.
   *
   * @var string
   */
  public $parent;
  protected $recaptchaOptionsConfigType = SecurityPolicyRecaptchaOptionsConfig::class;
  protected $recaptchaOptionsConfigDataType = '';
  /**
   * [Output Only] URL of the region where the regional security policy resides.
   * This field is not applicable to global security policies.
   *
   * @var string
   */
  public $region;
  protected $rulesType = SecurityPolicyRule::class;
  protected $rulesDataType = 'array';
  /**
   * [Output Only] Server-defined URL for the resource.
   *
   * @var string
   */
  public $selfLink;
  /**
   * User-provided name of the organization security policy. The name should be
   * unique in the organization in which the security policy is created. This
   * should only be used when SecurityPolicyType is CLOUD_ARMOR. The name must
   * be 1-63 characters long, and comply with
   * https://www.ietf.org/rfc/rfc1035.txt. Specifically, the name must be 1-63
   * characters long and match the regular expression
   * `[a-z]([-a-z0-9]*[a-z0-9])?` which means the first character must be a
   * lowercase letter, and all following characters must be a dash, lowercase
   * letter, or digit, except the last character, which cannot be a dash.
   *
   * @var string
   */
  public $shortName;
  /**
   * The type indicates the intended use of the security policy.        -
   * CLOUD_ARMOR: Cloud Armor backend security policies can    be configured to
   * filter incoming HTTP requests targeting backend services.    They filter
   * requests before they hit the origin servers.    - CLOUD_ARMOR_EDGE: Cloud
   * Armor edge security policies can    be configured to filter incoming HTTP
   * requests targeting backend services    (including Cloud CDN-enabled) as
   * well as backend buckets (Cloud Storage).    They filter requests before the
   * request is served from Google's cache.    - CLOUD_ARMOR_INTERNAL_SERVICE
   * (preview only): Cloud Armor    internal service policies can be configured
   * to filter HTTP requests    targeting services managed by Traffic Director
   * in a service mesh. They    filter requests before the request is served
   * from the application.
   *
   * - CLOUD_ARMOR_NETWORK: Cloud Armor network policies can be configured to
   * filter packets targeting network load balancing resources such as backend
   * services, target pools, target instances, and instances with external IPs.
   * They filter requests before the request is served from the application.
   *
   * This field can be set only at resource creation time.
   *
   * @var string
   */
  public $type;
  protected $userDefinedFieldsType = SecurityPolicyUserDefinedField::class;
  protected $userDefinedFieldsDataType = 'array';

  /**
   * @param SecurityPolicyAdaptiveProtectionConfig $adaptiveProtectionConfig
   */
  public function setAdaptiveProtectionConfig(SecurityPolicyAdaptiveProtectionConfig $adaptiveProtectionConfig)
  {
    $this->adaptiveProtectionConfig = $adaptiveProtectionConfig;
  }
  /**
   * @return SecurityPolicyAdaptiveProtectionConfig
   */
  public function getAdaptiveProtectionConfig()
  {
    return $this->adaptiveProtectionConfig;
  }
  /**
   * @param SecurityPolicyAdvancedOptionsConfig $advancedOptionsConfig
   */
  public function setAdvancedOptionsConfig(SecurityPolicyAdvancedOptionsConfig $advancedOptionsConfig)
  {
    $this->advancedOptionsConfig = $advancedOptionsConfig;
  }
  /**
   * @return SecurityPolicyAdvancedOptionsConfig
   */
  public function getAdvancedOptionsConfig()
  {
    return $this->advancedOptionsConfig;
  }
  /**
   * A list of associations that belong to this policy.
   *
   * @param SecurityPolicyAssociation[] $associations
   */
  public function setAssociations($associations)
  {
    $this->associations = $associations;
  }
  /**
   * @return SecurityPolicyAssociation[]
   */
  public function getAssociations()
  {
    return $this->associations;
  }
  /**
   * [Output Only] Creation timestamp inRFC3339 text format.
   *
   * @param string $creationTimestamp
   */
  public function setCreationTimestamp($creationTimestamp)
  {
    $this->creationTimestamp = $creationTimestamp;
  }
  /**
   * @return string
   */
  public function getCreationTimestamp()
  {
    return $this->creationTimestamp;
  }
  /**
   * @param SecurityPolicyDdosProtectionConfig $ddosProtectionConfig
   */
  public function setDdosProtectionConfig(SecurityPolicyDdosProtectionConfig $ddosProtectionConfig)
  {
    $this->ddosProtectionConfig = $ddosProtectionConfig;
  }
  /**
   * @return SecurityPolicyDdosProtectionConfig
   */
  public function getDdosProtectionConfig()
  {
    return $this->ddosProtectionConfig;
  }
  /**
   * An optional description of this resource. Provide this property when you
   * create the resource.
   *
   * @param string $description
   */
  public function setDescription($description)
  {
    $this->description = $description;
  }
  /**
   * @return string
   */
  public function getDescription()
  {
    return $this->description;
  }
  /**
   * Specifies a fingerprint for this resource, which is essentially a hash of
   * the metadata's contents and used for optimistic locking. The fingerprint is
   * initially generated by Compute Engine and changes after every request to
   * modify or update metadata. You must always provide an up-to-date
   * fingerprint hash in order to update or change metadata, otherwise the
   * request will fail with error412 conditionNotMet.
   *
   * To see the latest fingerprint, make get() request to the security policy.
   *
   * @param string $fingerprint
   */
  public function setFingerprint($fingerprint)
  {
    $this->fingerprint = $fingerprint;
  }
  /**
   * @return string
   */
  public function getFingerprint()
  {
    return $this->fingerprint;
  }
  /**
   * [Output Only] The unique identifier for the resource. This identifier is
   * defined by the server.
   *
   * @param string $id
   */
  public function setId($id)
  {
    $this->id = $id;
  }
  /**
   * @return string
   */
  public function getId()
  {
    return $this->id;
  }
  /**
   * [Output only] Type of the resource. Alwayscompute#securityPolicyfor
   * security policies
   *
   * @param string $kind
   */
  public function setKind($kind)
  {
    $this->kind = $kind;
  }
  /**
   * @return string
   */
  public function getKind()
  {
    return $this->kind;
  }
  /**
   * A fingerprint for the labels being applied to this security policy, which
   * is essentially a hash of the labels set used for optimistic locking. The
   * fingerprint is initially generated by Compute Engine and changes after
   * every request to modify or update labels. You must always provide an up-to-
   * date fingerprint hash in order to update or change labels.
   *
   * To see the latest fingerprint, make get() request to the security policy.
   *
   * @param string $labelFingerprint
   */
  public function setLabelFingerprint($labelFingerprint)
  {
    $this->labelFingerprint = $labelFingerprint;
  }
  /**
   * @return string
   */
  public function getLabelFingerprint()
  {
    return $this->labelFingerprint;
  }
  /**
   * Labels for this resource. These can only be added or modified by
   * thesetLabels method. Each label key/value pair must comply withRFC1035.
   * Label values may be empty.
   *
   * @param string[] $labels
   */
  public function setLabels($labels)
  {
    $this->labels = $labels;
  }
  /**
   * @return string[]
   */
  public function getLabels()
  {
    return $this->labels;
  }
  /**
   * Name of the resource. Provided by the client when the resource is created.
   * The name must be 1-63 characters long, and comply withRFC1035.
   * Specifically, the name must be 1-63 characters long and match the regular
   * expression `[a-z]([-a-z0-9]*[a-z0-9])?` which means the first character
   * must be a lowercase letter, and all following characters must be a dash,
   * lowercase letter, or digit, except the last character, which cannot be a
   * dash.
   *
   * @param string $name
   */
  public function setName($name)
  {
    $this->name = $name;
  }
  /**
   * @return string
   */
  public function getName()
  {
    return $this->name;
  }
  /**
   * [Output Only] The parent of the security policy.
   *
   * @param string $parent
   */
  public function setParent($parent)
  {
    $this->parent = $parent;
  }
  /**
   * @return string
   */
  public function getParent()
  {
    return $this->parent;
  }
  /**
   * @param SecurityPolicyRecaptchaOptionsConfig $recaptchaOptionsConfig
   */
  public function setRecaptchaOptionsConfig(SecurityPolicyRecaptchaOptionsConfig $recaptchaOptionsConfig)
  {
    $this->recaptchaOptionsConfig = $recaptchaOptionsConfig;
  }
  /**
   * @return SecurityPolicyRecaptchaOptionsConfig
   */
  public function getRecaptchaOptionsConfig()
  {
    return $this->recaptchaOptionsConfig;
  }
  /**
   * [Output Only] URL of the region where the regional security policy resides.
   * This field is not applicable to global security policies.
   *
   * @param string $region
   */
  public function setRegion($region)
  {
    $this->region = $region;
  }
  /**
   * @return string
   */
  public function getRegion()
  {
    return $this->region;
  }
  /**
   * A list of rules that belong to this policy. There must always be a default
   * rule which is a rule with priority 2147483647 and match all condition (for
   * the match condition this means match  "*" for srcIpRanges and for the
   * networkMatch condition every field must be either match "*" or not set). If
   * no rules are provided when creating a security policy, a default rule with
   * action "allow" will be added.
   *
   * @param SecurityPolicyRule[] $rules
   */
  public function setRules($rules)
  {
    $this->rules = $rules;
  }
  /**
   * @return SecurityPolicyRule[]
   */
  public function getRules()
  {
    return $this->rules;
  }
  /**
   * [Output Only] Server-defined URL for the resource.
   *
   * @param string $selfLink
   */
  public function setSelfLink($selfLink)
  {
    $this->selfLink = $selfLink;
  }
  /**
   * @return string
   */
  public function getSelfLink()
  {
    return $this->selfLink;
  }
  /**
   * User-provided name of the organization security policy. The name should be
   * unique in the organization in which the security policy is created. This
   * should only be used when SecurityPolicyType is CLOUD_ARMOR. The name must
   * be 1-63 characters long, and comply with
   * https://www.ietf.org/rfc/rfc1035.txt. Specifically, the name must be 1-63
   * characters long and match the regular expression
   * `[a-z]([-a-z0-9]*[a-z0-9])?` which means the first character must be a
   * lowercase letter, and all following characters must be a dash, lowercase
   * letter, or digit, except the last character, which cannot be a dash.
   *
   * @param string $shortName
   */
  public function setShortName($shortName)
  {
    $this->shortName = $shortName;
  }
  /**
   * @return string
   */
  public function getShortName()
  {
    return $this->shortName;
  }
  /**
   * The type indicates the intended use of the security policy.        -
   * CLOUD_ARMOR: Cloud Armor backend security policies can    be configured to
   * filter incoming HTTP requests targeting backend services.    They filter
   * requests before they hit the origin servers.    - CLOUD_ARMOR_EDGE: Cloud
   * Armor edge security policies can    be configured to filter incoming HTTP
   * requests targeting backend services    (including Cloud CDN-enabled) as
   * well as backend buckets (Cloud Storage).    They filter requests before the
   * request is served from Google's cache.    - CLOUD_ARMOR_INTERNAL_SERVICE
   * (preview only): Cloud Armor    internal service policies can be configured
   * to filter HTTP requests    targeting services managed by Traffic Director
   * in a service mesh. They    filter requests before the request is served
   * from the application.
   *
   * - CLOUD_ARMOR_NETWORK: Cloud Armor network policies can be configured to
   * filter packets targeting network load balancing resources such as backend
   * services, target pools, target instances, and instances with external IPs.
   * They filter requests before the request is served from the application.
   *
   * This field can be set only at resource creation time.
   *
   * Accepted values: CLOUD_ARMOR, CLOUD_ARMOR_EDGE, CLOUD_ARMOR_NETWORK
   *
   * @param self::TYPE_* $type
   */
  public function setType($type)
  {
    $this->type = $type;
  }
  /**
   * @return self::TYPE_*
   */
  public function getType()
  {
    return $this->type;
  }
  /**
   * Definitions of user-defined fields for CLOUD_ARMOR_NETWORK policies. A
   * user-defined field consists of up to 4 bytes extracted from a fixed offset
   * in the packet, relative to the IPv4, IPv6, TCP, or UDP header, with an
   * optional mask to select certain bits. Rules may then specify matching
   * values for these fields.
   *
   * Example:
   *
   *  userDefinedFields:  - name: "ipv4_fragment_offset"    base: IPV4
   * offset: 6    size: 2    mask: "0x1fff"
   *
   * @param SecurityPolicyUserDefinedField[] $userDefinedFields
   */
  public function setUserDefinedFields($userDefinedFields)
  {
    $this->userDefinedFields = $userDefinedFields;
  }
  /**
   * @return SecurityPolicyUserDefinedField[]
   */
  public function getUserDefinedFields()
  {
    return $this->userDefinedFields;
  }
}

// Adding a class alias for backwards compatibility with the previous class name.
class_alias(SecurityPolicy::class, 'Google_Service_Compute_SecurityPolicy');
