<?php
/*
 * Copyright 2014 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */

namespace Google\Service\CloudRetail;

class GoogleCloudRetailV2CreateModelMetadata extends \Google\Model
{
  /**
   * The resource name of the model that this create applies to. Format: `projec
   * ts/{project_number}/locations/{location_id}/catalogs/{catalog_id}/models/{m
   * odel_id}`
   *
   * @var string
   */
  public $model;

  /**
   * The resource name of the model that this create applies to. Format: `projec
   * ts/{project_number}/locations/{location_id}/catalogs/{catalog_id}/models/{m
   * odel_id}`
   *
   * @param string $model
   */
  public function setModel($model)
  {
    $this->model = $model;
  }
  /**
   * @return string
   */
  public function getModel()
  {
    return $this->model;
  }
}

// Adding a class alias for backwards compatibility with the previous class name.
class_alias(GoogleCloudRetailV2CreateModelMetadata::class, 'Google_Service_CloudRetail_GoogleCloudRetailV2CreateModelMetadata');
