@extends('front')
@section('title', $data['seo_title'] ?? $companyName)
@section('description', $data['seo_description'] ?? $companyName)
@section('keywords', $data['seo_tag'] ?? $companyName)
@section('content')
    @if ($data['status'] == 1) <!-- Check if the page status is 1 -->
        @foreach ($content_sections as $section)
            @if (isset($section['section_type'], $section['status']) && $section['status'] == 1)
                @if ($section['section_type'] === 'banner')
                    @include('partials.hero-section', ['section' => $section])
                @elseif ($section['section_type'] === 'category')
                    @include('partials.category-section', ['section' => $section])
                @elseif ($section['section_type'] === 'featured_service')
                    @include('partials.service-section', ['section' => $section])
                @elseif ($section['section_type'] === 'popular_service')
                    @include('partials.popular-section', ['popularSection' => $section])
                @elseif ($section['section_type'] === 'how_it_works')
                    @include('partials.how-it-work-section', ['section' => $section])
                @elseif ($section['section_type'] === 'service')
                    @include('partials.preferred-services-section')
                @elseif ($section['section_type'] === 'popular_provider')
                    @include('partials.popular_provider_section', ['section' => $section])
                @elseif ($section['section_type'] === 'rated_service')
                    @include('partials.rated_section', ['ratedSection' => $section])
                @elseif ($section['section_type'] === 'testimonial')
                    @include('partials.testimonial-section', ['section' => $section])
                @elseif ($section['section_type'] === 'become_provider')
                    @include('partials.provider-section', ['section' => $section])
                @elseif ($section['section_type'] === 'blog')
                    @include('partials.blog-section', ['section' => $section])
                @elseif ($section['section_type'] === 'business_with_us')
                    @include('partials.business-section', ['section' => $section])
                @elseif ($section['section_type'] === 'link')
                    @include('partials.link-section')
                @elseif ($section['section_type'] === 'about_us')
                    @include('partials.about-section', ['section' => $section])
                @elseif ($section['section_type'] === 'contact_us')
                    @include('partials.contact-section', ['section' => $section])
                @elseif ($section['section_type'] === 'terms_conditions')
                    @include('partials.terms-condition-section', ['section' => $section])
                @elseif ($section['section_type'] === 'privacy_policy')
                    @include('partials.privacy-policy-section', ['section' => $section])
                @elseif ($section['section_type'] === 'advertisement')
                    @include('partials.advertisement-section')
                @elseif ($section['section_type'] === 'multiple_section')
                    @include('partials.multiple-section', ['section' => $section])
                @elseif ($section['section_type'] === 'faq')
                    @include('partials.faq-section', ['section' => $section])
                @endif
            @endif
        @endforeach
    @endif
@endsection
